#!/bin/bash
#include <stdio.h>
#include <string.h>
#  
accelerate launch --main_process_port 29501 train_dreambooth_lora_new.py \
    --pretrained_model_name_or_path="runwayml/stable-diffusion-v1-5" \
    --instance_data_dir="dog" \
    --load_model_dir="output_test/" \
    --adapters="/home/  /cdf/implementations/AlignProp/checkpoints/adapters/aesthetic/epochs_10, /home/  /cdf/implementations/AlignProp/checkpoints/adapters/aesthetic_1/epochs_10, /home/  /cdf/implementations/AlignProp/checkpoints/adapters/aesthetic_2/epochs_10, /home/  /cdf/implementations/AlignProp/checkpoints/adapters/pickscore/epochs_10"\
    --output_dir="output_test" \
    --prompts="cheetah" \
    --instance_prompt="cheetah" \
    --resolution=512 \
    --train_batch_size=4 \
    --checkpointing_steps=200 \
    --learning_rate=0.1 \
    --lr_scheduler="cosine" \
    --lr_num_cycles=1 \
    --lr_warmup_steps=5 \
    --max_train_steps=200 \
    --validation_prompt="cheetah" \
    --validation_epochs=10 \
    --primal_per_dual=20 \
    --min_timestep=1 --max_timestep=999 \
    --lr_dual=2.0 \
    --constrained=1 \
    --const_thresholds="0.0" \
    --num_validation_images=4 \
    --num_inference_steps_val=25 \
    --num_inference_steps_train=25 \
    --rank=4 \
    --gradient_accumulation_steps=1 \
    --seed="0" \
    --guidance_scale=5.0 \
    --classifier_class_names="cheetah" \
    --project_name="dreambooth_lora_test8" \
    --report_to="wandb" \
    --gen_mode="cfg" \
    # --load_model_only=1 \
    # --resume_from_checkpoint="latest" \